﻿<%@ Import Namespace="Soneta.SrodkiTrwale" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" codePage="1200" AutoEventWireup="false"%>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
  <HEAD>
    <title>Zestaw środków trwałych</title>
    
    <meta name="GENERATOR" Content="Microsoft Visual Studio 7.0">
    <meta name="CODE_LANGUAGE" Content="C#">
    <meta name="vs_defaultClientScript" content="JavaScript">
    <meta name="vs_targetSchema" content="http://schemas.microsoft.com/intellisense/ie5">
    <script runat="server">
      void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
        SrodekTrwalyBaseHistoria srodekHist = (SrodekTrwalyBaseHistoria)args.Row;
        wsw.SrodekHistoria = srodekHist;
        wsw.Data = p.Aktualny;
        colWartoscBilansowaBrutto.EditValue = wsw.WartoscBilansowa.Value;
        colWartoscPodatkowaBrutto.EditValue = wsw.WartoscPodatkowa.Value;
      }
      
      WartosciSrodkaWorker wsw = null;
      ZestawyST.Params p = null;
      
      void Zestaw_OnLoad(Object sender, EventArgs args){
        wsw = new WartosciSrodkaWorker();
        ZestawST zestaw     = (ZestawST)DataContext1.Get(typeof(ZestawST));
        p       = (ZestawyST.Params)DataContext1.Get(typeof(ZestawyST.Params));
        Grid1.DataSource = zestaw.ElementyZestawuByData(p.Aktualny);
        
        ReportHeader1.Title =
          string.Format(ReportHeader1.Title,zestaw.Nazwa,zestaw.Opis,p.Aktualny);
      }
    </script>
  </HEAD>
  <body>
    <form id="Zestaw" method="post" runat="server" onload="Zestaw_OnLoad">
      <ea:DataContext id="DataContext1" runat="server" TypeName="Soneta.SrodkiTrwale.ZestawST,Soneta.Ksiega"></ea:DataContext><BR>
      <cc1:ReportHeader id="ReportHeader1" runat="server" title="Zestaw środków trwałych | Nazwa: {0} | Opis: {1} | Aktualność: {2}"></cc1:ReportHeader><BR>
      <ea:Grid id="Grid1" runat="server" RowTypeName="Soneta.SrodkiTrwale.SrodekTrwalyHistoria,Soneta.Ksiega" OnBeforeRow="Grid1_BeforeRow" ShowPrevAgrSum="InFooter" ShowPageSum="True" ShowAgrSum="True">
        <Columns>
          <ea:GridColumn Width="10" Align="Center" DataMember="#" Caption="Lp."></ea:GridColumn>
          <ea:GridColumn DataMember="Srodek" Total="Info" Caption="Środek"></ea:GridColumn>
          <ea:GridColumn Width="25" Align="Right" Total="Sum" Caption="Wartość bilansowa brutto" Format="{0:n}" ID="colWartoscBilansowaBrutto"></ea:GridColumn>
          <ea:GridColumn Width="25" Align="Right" Total="Sum" Caption="Wartość podatkowa brutto" Format="{0:n}" ID="colWartoscPodatkowaBrutto"></ea:GridColumn>
        </Columns>
      </ea:Grid><BR>
      <cc1:ReportFooter id="ReportFooter1" runat="server"></cc1:ReportFooter>
    </form>
  </body>
</HTML>

